#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "qmath.h"
/*#include "QDebug"*/

double firstNum;
bool userIsTypingSecondNumber = false;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    /* Connects digits to digit pressed slot */

    connect(ui->Zero_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->One_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Two_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Three_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Four_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Five_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Six_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Seven_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Eight_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));
    connect(ui->Nine_Btn, SIGNAL(released()), this, SLOT(digit_pressed()));

    /* Connects Positive Negetive and Percent buttons to unary operations slot */

    connect(ui->PosNeg_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));
    connect(ui->Percent_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));
    connect(ui->Sqrt_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));
    connect(ui->Sin_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));
    connect(ui->Cos_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));
    connect(ui->Tan_Btn, SIGNAL(released()), this, SLOT(unary_operation_pressed()));

    /* Connects Operation Buttons to binary operations slot */

    connect(ui->Add_Btn, SIGNAL(released()), this, SLOT(binary_operation_pressed()));
    connect(ui->Subtract_Btn, SIGNAL(released()), this, SLOT(binary_operation_pressed()));
    connect(ui->Multiply_Btn, SIGNAL(released()), this, SLOT(binary_operation_pressed()));
    connect(ui->Divide_Btn, SIGNAL(released()), this, SLOT(binary_operation_pressed()));
    connect(ui->Expo_Btn, SIGNAL(released()), this, SLOT(binary_operation_pressed()));

    /* Makes Binary Operations Checkable */
    ui->Add_Btn->setCheckable(true);
    ui->Subtract_Btn->setCheckable(true);
    ui->Multiply_Btn->setCheckable(true);
    ui->Divide_Btn->setCheckable(true);
    ui->Expo_Btn->setCheckable(true);

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::digit_pressed()
{
    /*qDebug() << "test";*/

    QPushButton * button = (QPushButton*)sender();

    double labelNumber;
    QString newLabel;


    if((ui->Add_Btn->isChecked() || ui->Subtract_Btn->isChecked()
            || ui->Multiply_Btn->isChecked() || ui->Divide_Btn->isChecked() || ui->Expo_Btn->isChecked())
            && (!userIsTypingSecondNumber))
    {
        labelNumber = button->text().toDouble();
        userIsTypingSecondNumber= true;
        newLabel = QString::number(labelNumber, 'g', 15);

    }
    else
    {
        if(ui->label->text().contains(".") && button->text() == "0")
        {
            newLabel = ui->label->text() + button->text();
        }
        else
        {
            labelNumber = (ui ->label -> text() + button->text()).toDouble();
            newLabel = QString::number(labelNumber, 'g', 15);
        }
    }


    ui->label->setText(newLabel);
}

void MainWindow::on_Decimal_Btn_released()
{
    ui->label->setText(ui->label->text() + ".");
}

void MainWindow::unary_operation_pressed()
{

    QPushButton * button = (QPushButton*) sender();
    double labelNumber;
    QString newLabel;

    if (button -> text() == "+/-")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber = labelNumber * -1;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }

    if (button->text() == "%")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber=labelNumber * .01;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }
    if (button->objectName() == "Sqrt_Btn")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber=qSqrt(labelNumber);
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }
    if (button->text() == "Sin")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber=qSin(labelNumber);
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }
    if (button->text() == "Cos")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber=qCos(labelNumber);
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }
    if (button->text() == "Tan")
    {
        labelNumber = ui->label->text().toDouble();
        labelNumber=qTan(labelNumber);
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
    }
}



void MainWindow::on_Clear_Btn_released()
{
    ui->Add_Btn->setChecked(false);
    ui->Subtract_Btn->setChecked(false);
    ui->Multiply_Btn->setChecked(false);
    ui->Divide_Btn->setChecked(false);
    ui->Expo_Btn->setChecked(false);
    ui->Sqrt_Btn->setChecked(false);

    userIsTypingSecondNumber = false;

    ui->label->setText("0");
}

void MainWindow::on_Answer_Btn_released()
{
    double labelNumber, secondNum;
    QString newLabel;

    secondNum = ui->label->text().toDouble();

    if(ui->Add_Btn->isChecked())
    {
        labelNumber = firstNum + secondNum;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
        ui->Add_Btn->setChecked(false);
    }
    else if(ui->Subtract_Btn->isChecked())
    {
        labelNumber = firstNum - secondNum;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
        ui->Subtract_Btn->setChecked(false);
    }
    else if(ui->Multiply_Btn->isChecked())
    {
        labelNumber = firstNum * secondNum;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
        ui->Multiply_Btn->setChecked(false);
    }
    else if(ui->Divide_Btn->isChecked())
    {
        labelNumber = firstNum / secondNum;
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
        ui->Divide_Btn->setChecked(false);
    }

  else if(ui->Expo_Btn->isChecked())
    {
        labelNumber = qPow(firstNum, secondNum);
        newLabel = QString::number(labelNumber, 'g', 15);
        ui->label->setText(newLabel);
        ui->Expo_Btn->setChecked(false);
    }


    userIsTypingSecondNumber = false;

}

void MainWindow::binary_operation_pressed()
{
    QPushButton * button = (QPushButton*) sender();

    firstNum = ui->label->text().toDouble();

    button->setChecked(true);
}
